<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'foxiz_register_options_block_grid_1' ) ) {
	function foxiz_register_options_block_grid_1() {

		$prefix = 'grid_1_';

		return [
			'id'         => 'foxiz_config_section_styling_grid_1',
			'title'      => esc_html__( 'Grid 1', 'foxiz' ),
			'icon'       => 'el el-th-large',
			'subsection' => true,
			'desc'       => esc_html__( 'These are settings for the Grid 1. They are overridden by "Block Design" (for Elementor pages) and "Blog Design" (for the Blog and Archive pages).', 'foxiz' ),
			'fields'     => [
				[
					'id'    => $prefix . 'info',
					'type'  => 'info',
					'class' => 'layout-info',
					'style' => 'success',
					'desc'  => html_entity_decode( '<img src="' . foxiz_get_file_uri( 'backend/assets/' . str_replace( '_', '-', rtrim( $prefix, '_' ) ) . '.jpg' ) . '" alt="' . esc_attr__( 'grid', 'foxiz' ) . '">' ),
				],
				[
					'id'     => 'section_start_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Featured Image', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'crop_size',
					'title'       => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle'    => esc_html__( 'Choose a featured image size to optimize the columns setting.', 'foxiz' ),
					'description' => esc_html__( 'This setting will also apply to the default crop size of the "Foxiz - Overlay" and "Foxiz - Overlay Flex" blocks.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_crop_size(),
					'default'     => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Category', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_category',
					'title'    => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_extended_entry_category(),
					'default'  => 'bg-1',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Title', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Meta', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'desc'     => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [ 'avatar', 'author', 'update' ],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review(),
					'default'  => 'replace',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'options'  => foxiz_config_review_desc_dropdown( false ),
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'default'  => '1',
				],
				[
					'id'       => $prefix . 'sponsor_meta',
					'title'    => esc_html__( 'Sponsored Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Replace entry meta with sponsored meta for sponsored posts.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true,
				],
				[
					'id'       => $prefix . 'tablet_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on tablet devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'mobile_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on mobile devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'     => 'section_end_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Bookmark', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'switch',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Format', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format(),
					'default'  => 'bottom',
				],
				[
					'id'     => 'section_end_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Excerpt', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => 12,
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Read More', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'readmore',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Centering', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'center_mode',
					'type'     => 'switch',
					'title'    => esc_html__( 'Centering Content', 'foxiz' ),
					'subtitle' => esc_html__( 'Centering text and elements for the post listing.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_block_grid_2' ) ) {
	function foxiz_register_options_block_grid_2() {

		$prefix = 'grid_2_';

		return [
			'id'         => 'foxiz_config_section_styling_grid_2',
			'title'      => esc_html__( 'Grid 2', 'foxiz' ),
			'icon'       => 'el el-th-large',
			'subsection' => true,
			'desc'       => esc_html__( 'These are settings for the grid 2 layout. They are overridden by "Block Design" (for Elementor pages) and "Blog Design" (for the Blog and Archive pages).', 'foxiz' ),
			'fields'     => [
				[
					'id'    => $prefix . 'info',
					'type'  => 'info',
					'class' => 'layout-info',
					'style' => 'success',
					'desc'  => html_entity_decode( '<img src="' . foxiz_get_file_uri( 'backend/assets/' . str_replace( '_', '-', rtrim( $prefix, '_' ) ) . '.jpg' ) . '" alt="' . esc_attr__( 'grid', 'foxiz' ) . '">' ),
				],
				[
					'id'     => 'section_start_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Featured Image', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],

				[
					'id'     => 'section_start_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Category', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_category',
					'title'    => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_extended_entry_category(),
					'default'  => 'bg-1',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Title', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Meta', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'desc'     => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [ 'avatar', 'author', 'update' ],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review(),
					'default'  => 'replace',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'options'  => foxiz_config_review_desc_dropdown( false ),
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'default'  => '1',
				],
				[
					'id'       => $prefix . 'sponsor_meta',
					'title'    => esc_html__( 'Sponsored Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Replace entry meta with sponsored meta for sponsored posts.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true,
				],
				[
					'id'       => $prefix . 'tablet_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on tablet devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'mobile_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on mobile devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'     => 'section_end_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Bookmark', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'switch',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Format', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format(),
					'default'  => 'bottom',
				],
				[
					'id'     => 'section_end_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Excerpt', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => 12,
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Read More', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'readmore',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Centering', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'center_mode',
					'type'     => 'switch',
					'title'    => esc_html__( 'Centering Content', 'foxiz' ),
					'subtitle' => esc_html__( 'Centering text and elements for the post listing.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_block_grid_small_1' ) ) {
	function foxiz_register_options_block_grid_small_1() {

		$prefix = 'grid_small_1_';

		return [
			'id'         => 'foxiz_config_section_styling_grid_small_1',
			'title'      => esc_html__( 'Small Grid', 'foxiz' ),
			'icon'       => 'el el-th-large',
			'subsection' => true,
			'desc'       => esc_html__( 'These are settings for the small grid layout. They are overridden by "Block Design" (for Elementor pages) and "Blog Design" (for the Blog and Archive pages)', 'foxiz' ),
			'fields'     => [
				[
					'id'    => $prefix . 'info',
					'type'  => 'info',
					'class' => 'layout-info',
					'style' => 'success',
					'desc'  => html_entity_decode( '<img src="' . foxiz_get_file_uri( 'backend/assets/' . str_replace( '_', '-', rtrim( $prefix, '_' ) ) . '.jpg' ) . '" alt="' . esc_attr__( 'small grid', 'foxiz' ) . '">' ),
				],
				[
					'id'     => 'section_start_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Featured Image', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Category', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_category',
					'title'    => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_extended_entry_category(),
					'default'  => 'bg-1',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => 'mobile',
				],
				[
					'id'     => 'section_end_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Title', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Meta', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'desc'     => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [ 'update' ],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review(),
					'default'  => 'replace',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'options'  => foxiz_config_review_desc_dropdown( false ),
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'default'  => '-1',
				],
				[
					'id'       => $prefix . 'sponsor_meta',
					'title'    => esc_html__( 'Sponsored Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Replace entry meta with sponsored meta for sponsored posts.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true,
				],
				[
					'id'       => $prefix . 'tablet_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on tablet devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'mobile_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on mobile devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'     => 'section_end_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Bookmark', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'switch',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Format', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format(),
					'default'  => 'bottom',
				],
				[
					'id'     => 'section_end_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Excerpt', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Read More', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'readmore',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Centering', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'center_mode',
					'type'     => 'switch',
					'title'    => esc_html__( 'Centering Content', 'foxiz' ),
					'subtitle' => esc_html__( 'Centering text and elements for the post listing.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_block_grid_box_1' ) ) {
	function foxiz_register_options_block_grid_box_1() {

		$prefix = 'grid_box_1_';

		return [
			'id'         => 'foxiz_config_section_styling_grid_box_1',
			'title'      => esc_html__( 'Boxed Grid 1', 'foxiz' ),
			'icon'       => 'el el-th-large',
			'subsection' => true,
			'desc'       => esc_html__( 'These are settings for the boxed grid 1. They are overridden by "Block Design" (for Elementor pages) and "Blog Design" (for the Blog and Archive pages).', 'foxiz' ),
			'fields'     => [
				[
					'id'    => $prefix . 'info',
					'type'  => 'info',
					'class' => 'layout-info',
					'style' => 'success',
					'desc'  => html_entity_decode( '<img src="' . foxiz_get_file_uri( 'backend/assets/' . str_replace( '_', '-', rtrim( $prefix, '_' ) ) . '.jpg' ) . '" alt="' . esc_attr__( 'boxed grid', 'foxiz' ) . '">' ),
				],
				[
					'id'     => 'section_start_' . $prefix . 'box_style',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Boxed', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'box_style',
					'title'    => esc_html__( 'Box Style', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a box style for the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_box_style(),
					'default'  => 'bg',
				],
				[
					'id'          => $prefix . 'box_color',
					'title'       => esc_html__( 'Box Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the background or border style.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => $prefix . 'dark_box_color',
					'title'       => esc_html__( 'Dark Mode - Box Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the background or border style in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'box_style',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Featured Image', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Category', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_category',
					'title'    => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_extended_entry_category(),
					'default'  => 'bg-1,big',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Title', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Meta', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'desc'     => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [ 'avatar', 'author', 'update' ],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review(),
					'default'  => 'replace',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'options'  => foxiz_config_review_desc_dropdown( false ),
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'default'  => '1',
				],
				[
					'id'       => $prefix . 'sponsor_meta',
					'title'    => esc_html__( 'Sponsored Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Replace entry meta with sponsored meta for sponsored posts.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true,
				],
				[
					'id'       => $prefix . 'tablet_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on tablet devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'mobile_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on mobile devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'     => 'section_end_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Bookmark', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'switch',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Format', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format(),
					'default'  => 'bottom',
				],
				[
					'id'     => 'section_end_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Excerpt', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => 12,
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Read More', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'readmore',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Centering', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'center_mode',
					'type'     => 'switch',
					'title'    => esc_html__( 'Centering Content', 'foxiz' ),
					'subtitle' => esc_html__( 'Centering text and elements for the post listing.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_block_grid_box_2' ) ) {
	function foxiz_register_options_block_grid_box_2() {

		$prefix = 'grid_box_2_';

		return [
			'id'         => 'foxiz_config_section_styling_grid_box_2',
			'title'      => esc_html__( 'Boxed Grid 2', 'foxiz' ),
			'icon'       => 'el el-th-large',
			'subsection' => true,
			'desc'       => esc_html__( 'These are settings for the boxed grid 2. They are overridden by "Block Design" (for Elementor pages) and "Blog Design" (for the Blog and Archive pages).', 'foxiz' ),
			'fields'     => [
				[
					'id'    => $prefix . 'info',
					'type'  => 'info',
					'class' => 'layout-info',
					'style' => 'success',
					'desc'  => html_entity_decode( '<img src="' . foxiz_get_file_uri( 'backend/assets/' . str_replace( '_', '-', rtrim( $prefix, '_' ) ) . '.jpg' ) . '" alt="' . esc_attr__( 'boxed grid', 'foxiz' ) . '">' ),
				],
				[
					'id'     => 'section_start_' . $prefix . 'box_style',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Boxed', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'box_style',
					'title'    => esc_html__( 'Box Style', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a box style for the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_box_style(),
					'default'  => 'bg',
				],
				[
					'id'          => $prefix . 'box_color',
					'title'       => esc_html__( 'Box Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the background or border style.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => $prefix . 'dark_box_color',
					'title'       => esc_html__( 'Dark Mode - Box Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the background or border style in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'box_style',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Featured Image', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'featured',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Category', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_category',
					'title'    => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_extended_entry_category(),
					'default'  => 'bg-1',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'category',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Title', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'title',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Meta', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'desc'     => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [ 'avatar', 'author', 'update' ],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review(),
					'default'  => 'replace',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'options'  => foxiz_config_review_desc_dropdown( false ),
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'default'  => '1',
				],
				[
					'id'       => $prefix . 'sponsor_meta',
					'title'    => esc_html__( 'Sponsored Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Replace entry meta with sponsored meta for sponsored posts.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true,
				],
				[
					'id'       => $prefix . 'tablet_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on tablet devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'mobile_hide_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you would like to hide on mobile devices. In case of long meta tags, it would be useful.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'     => 'section_end_' . $prefix . 'meta',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Bookmark', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'switch',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'bookmark',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Format', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format(),
					'default'  => 'bottom',
				],
				[
					'id'     => 'section_end_' . $prefix . 'format',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Excerpt', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => 12,
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => foxiz_config_hide_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Read More', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'readmore',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'readmore',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Centering', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'center_mode',
					'type'     => 'switch',
					'title'    => esc_html__( 'Centering Content', 'foxiz' ),
					'subtitle' => esc_html__( 'Centering text and elements for the post listing.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_' . $prefix . 'centered',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}